varying vec2 		texcoord;

uniform sampler2D 	bg,
					bmp,
					tex,
					depthBG;

varying vec4 		pos;
varying vec4		eyepos;
uniform vec2		density;
uniform vec3		refrColor;
uniform vec3		diffuseColor;

#ifdef BUMP2

	varying vec2 		texcoord1;
	uniform sampler2D 	bmp1;

#endif

#ifdef PSYSTEM

	varying float 	life;

#else
	#ifdef CUBEREFL

		uniform vec3		lightDir;
		uniform float		lightscale;
		uniform vec3		lightcolor;

		uniform samplerCube	reflCube;
		varying vec3		w0,
							w1,
							w2;
		varying vec3		viewDir;
		uniform float		shininess;
		uniform vec2		fresnel;

	#endif

#endif

void main()
{
	vec4 refl=vec4(0.0,0.0,0.0,0.0);
	vec4 normalColor=texture2D(bmp,texcoord.st);
	vec3 normal=(normalColor.xyz*2.0)-1.0;
	normalize(normal);
	vec4 texColor=texture2D(tex,texcoord.st);

#ifdef BUMP2

	vec4 normalColor1=texture2D(bmp1,texcoord1.st);
	vec3 normal1=(normalColor1.xyz*2.0)-1.0;
	vec3 normal2=normal;
	normal=(normal2+normal1)*0.5;
	normalize(normal);

#endif

	vec2 UV=(pos.xy/pos.w)*0.5+0.5;
	float depth=texture2D(depthBG,UV).z;
	
#ifdef PSYSTEM

	UV+=normal.xy*density.x*life;
	normalColor.a*=life;

#else

	UV+=normal.xy*density.x;
	
	#ifdef CUBEREFL
	
		vec3 N;
		N.x=dot(w0,normal);
		N.y=dot(w1,normal);
		N.z=dot(w2,normal);

		vec3 vdir=normalize(viewDir);
		vec3 reflection = reflect(vdir,N);
		refl=textureCube(reflCube,reflection.xyz)*shininess;
		refl+=pow(1.0-clamp(dot(N,vdir),0.0,1.0),fresnel.x)*fresnel.y;
		
		//vec3 light = clamp(dot(N,lightDir),0.0,1.0)*lightcolor*lightscale*diffuseColor*shininess;
	
	#endif

#endif

	UV=clamp(UV,0.0,1.0);
	float dist=(clamp(abs(depth-eyepos.z)*density.y,0.0,1.0));
	vec3 finalcolor=( (1.0-dist)*texture2D(bg,UV*0.25).rgb + refrColor*dist )*diffuseColor + refl;
	gl_FragColor.rgb=/*light +*/ (finalcolor*(1.0-texColor.a) + texColor.rgb*texColor.a);
}
